/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSecurityToken.h,v 1.3 1999/12/07 06:08:01 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSecurityToken_h	// [
#define Included_CSecurityToken_h

#include "pgpClassesConfig.h"

_PGP_BEGIN

// Class CSecurityToken

class CSecurityToken
{
	NOT_COPYABLE(CSecurityToken)

public:
	CSecurityToken();
	~CSecurityToken();

	PGPBoolean	IsProcessIdAssigned() const {return mIsProcIdAssigned;}
	PGPBoolean	IsTokenSet() const {return mIsTokenSet;}
	PGPUInt32	GetOriginalProcessId() const {return mProcessId;}

	CComboError	AssignProcessId(PGPUInt32 procId);
	void		UnassignProcessId();

	void	ImpersonateToken();
	void	RevertToSelf();

private:
	PGPBoolean	mIsProcIdAssigned;
	PGPBoolean	mIsTokenSet;

	PGPUInt32	mProcessId;
	HANDLE		mTokenHandle;

	CComboError	DuplicateTokenOfProcess(PGPUInt32 procId, HANDLE& token);
};

_PGP_END

#endif	// ] Included_CSecurityToken_h
